# Operating on the semantic graph

All model configurations in Simantics are stored into a semantic graph database.
Therefore it is the most primitive interface for accessing Simantics and in
principle everything is doable with it, although sometimes with a great effort.

## Understanding semantic graphs

The best tool for discovering how the model configuration is represented
in the Simantics, is Graph debugger. It can be opened from
**Window/Show View/Other**. Resources can be dragged to the debugger
from the model browser.

The debugger shows the URI of the resource and all statements related
to it.

## Accessing resources

::data[Simantics/DB/Resource]
::value[Simantics/DB/resource,Simantics/DB/relativeResource,Simantics/DB/possibleResource,Simantics/DB/uriOf]
::value[Simantics/DB/currentModel]

## Navigating

::value[Simantics/DB/#,Simantics/DB/possibleObject,Simantics/DB/singleObject]
::data[Simantics/DB/Statement]
::value[Simantics/DB/statements,Simantics/DB/singleStatement]

## Reading literal values

::value[Simantics/DB/relatedValue, Simantics/DB/nameOf]

## Type queries

::value[Simantics/DB/isInstanceOf, Simantics/DB/isSubrelationOf, Simantics/DB/isInheritedFrom]
::value[Simantics/DB/singleTypeOf, Simantics/DB/possibleTypeOf] 

## Transactions

The graph database can be accessed only in reading or writing transactions. The SCL console
creates the transaction automatically if necessary, but sometimes it is necessary to control
manually where the transactions are started.

::value[Simantics/DB/syncRead, Simantics/DB/syncWrite, Simantics/DB/asyncRead, Simantics/DB/asyncWrite] 

## Writing

::value[Simantics/DB/newResource, Simantics/DB/claim, Simantics/DB/claimRelatedValue]
::value[Simantics/DB/deny]

## Entities

::class[Simantics/Entity/Entity]

## Searching

::value[Simantics/Model/searchByType, Simantics/Model/searchByTypeShallow, Simantics/Model/searchByTypeAndName]
::value[Simantics/Model/searchByTypeAndNameShallow, Simantics/Model/searchByQuery, Simantics/Model/searchByQueryShallow]
    Simantics/Model/searchByTypeAndFilter